<?php

include('../config/constant.php');
include('../includes/header.php');
include('../includes/navbar.php');
?>
<!-- Begin Page Content-->
<div class="container-fluid">


  <!-- Button trigger modal -->

  <div class="card shadow mb-4">
    <div class="card-header py-3">
      <h6 class="m-0 font weight-bold text-primary">

        <div class="modal fade" id="testModal" tabindex="1" role="dialog" aria-labelledby="examplemodalLabel" aria-hidden="true">
          <div class="modal-dialog" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Testimonials</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <form action="../testimonals/add_testimonals.php" id="addTestForm" method="POST" enctype="multipart/form-data">
                  <div class="modal-body">
                    <div class="form-group">

                      <input type="hidden" name="id" id="id" class="form-control" placeholder="Enter Id">
                    </div>
                    <div class="form-group">
                      <label>Title</label>
                      <input type="text" name="title" id="title" class="form-control" placeholder="Enter  Title">
                    </div>
                    <div class="form-group">
                      <label>SubTitle</label>
                      <input type="text" name="subtitle" id="subtitle" class="form-control" placeholder="Enter  SubTitle">
                    </div>
                    <div class="form-group">
                      <label>Description</label>
                      <input type="text" name="description" id="description" class="form-control" placeholder="Enter Description">
                    </div>
                     <div class="form-group">
                        <label for="img">Select image:</label>
                      <input type="file" id="image" name="image" accept="image/* required" >
                    </div>
                  </div>
                  <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" name="registerbtn" class="registerbtn btn-primary btn" onclick="saveTest();">Save</button>
                  </div>
                </div></form>
              </div>
            </div>
          </div>
          <div class="card-body">
            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#testModal" style="float: right">
          Add Testimonials
        </button>
        <br/>
        <br/>
        <br/>

            <div class="table-responsive">
              <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                <thead>
                  <tr>
                    <th>ID</th>
                    <th>Title</th>
                    <th>SubTitle</th>
                    <th>Descripton</th>
                    <th>Image</th>
                    <th>Created_at</th>
                    <th>Updated_at</th>
                    <th>EDIT</th>
                    <th>DELETE</th>
                  </tr>
                </thead>
                <tbody>
                  <!-- append using getAllServices() function -->
                </tbody>
              </table>   
            </div></div>
          </div></div>
          <!-- End of Main Content -->


          <?php
          include('../includes/scripts.php');
          include('../includes/footer.php');
          ?>
          <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.form/4.3.0/jquery.form.min.js" ></script>
          <script type="text/javascript">
            $(document).ready(function(){
              getAllTest();
            });

            function saveTest(){
              var options = {
                beforeSend: function () {
              //anything before sending request eg loader etc....
            },
            success: function (res) {
              // once receive response from backend
              //parese json
              var json = $.parseJSON(res);
              if(json.status=='success'){
                alert(json.message);
                $('#testModal').modal('hide');
                $('#id').val('');
                $('#title').val('');
                $('#subtitle').val('');
                $('#description').val('');
                $('#image').val('');
                getAllTest();
              }
              else{
                alert(json.message);
              }
              
            },
            error: function (response) {

            }        
          };
          $('#addTestForm').ajaxForm(options);
        }


        function editTest(id){
 //alert(id);
$('#testModal').modal('show');
$('#id').val(id);

$.ajax({
  type: "POST",
  data: 'id=' + id,
  url: '../testimonals/get_testimonals_by_id.php',
  success: function (response) {
    console.log(response)
    var json = $.parseJSON(response);

    $('#id').val(json[0].id);
    $('#title').val(json[0].title);
    $('#subtitle').val(json[0].subtitle);
    $('#description').val(json[0].description);
    $('#image').val(json[0].image);
  }
});
}

function deleteTest(id){
  if(confirm("Are you sure to delete")){


   $.ajax({
    type: "POST",
    data: 'id=' + id,
    url: '../testimonals/delete_testimonals.php',
    success: function (response) {
      console.log(response)
      var json = $.parseJSON(response);

      if(json.status=='success'){
        alert(json.message);
        getAllTest();
      }
      else{
        alert(json.message);
      }

    }
  });
 }
}

function getAllTest(){
  $.ajax({
    type: "POST",
    data: 'id=' + id,
    url: '../testimonals/get_all_testimonals.php',
    success: function (response) {

      var json = $.parseJSON(response);
      var html = "";
      $('#dataTable tbody').html(html);

      for(i=0;i<json.length;i++){
        html = html+`
        <tr>
        <td>`+(i+1)+`</td>
        <td>`+json[i].title+`</td>
        <td>`+json[i].subtitle+`</td>
        <td>`+json[i].description+`</td>
        <td>`+json[i].image+`</td>
        <td>`+json[i].created_at+`</td>
        <td>`+json[i].updated_at+`</td>
        <td> 
        <button type="button" class="btn btn-success" onclick="editTest(`+json[i].id+`);">
        <span class="glyphicon glyphicon-plus"></span> Edit</button>
        </td>
        <td>
        <button type="button" class="btn btn-danger" onclick="deleteTest(`+json[i].id+`);">
        <span class="glyphicon glyphicon-plus"></span> DELETE</button>
        </td> 
        </div>
        </tr>`;
      }
      $('#dataTable tbody').html(html);
    }
  });
}



</script>
